/*

selsetskin.cpp

Selection set skinning stuff should be migrated here

*/

#include "stdafx.h"
#include "DffExp.h"
#include "modstack.h"
#include "matrixmangle.h"
#include "utilities.h"

#define EDITMESH_CLASS_ID			0x00050

static Modifier * 
FindEditMeshModifier (INode* nodePtr)
{
    return FindModifier( nodePtr, Class_ID(EDITMESH_CLASS_ID,0) );
}

void
DFFExport::CalculateSelSetVertexBoneMap(INode *node, TriObject *triObject, RwInt32 *vertexMap)
{
    int set;                     
    int numNamedSets;
    int i;
    Mesh *mesh = &triObject->mesh;
    Object *obj = node->GetObjectRef();
    
    skinMatrixWeights = (RwMatrixWeights *)RwMalloc(sizeof(RwMatrixWeights) * m_remapper.GetNumVertices());
    skinVertexIndices = (RwUInt32 *)RwMalloc(sizeof(RwUInt32) * m_remapper.GetNumVertices());        
    for (i = 0; i < m_remapper.GetNumVertices(); i++)
    {
        skinVertexIndices[vertexMap[i]] = 0;
        skinMatrixWeights[vertexMap[i]].w0 = 0.0f;
        skinMatrixWeights[vertexMap[i]].w1 = 0.0f;
        skinMatrixWeights[vertexMap[i]].w2 = 0.0f;
        skinMatrixWeights[vertexMap[i]].w3 = 0.0f;
    }

    IMeshSelectData *imsd = NULL;

    if (triObject == obj)
    {
        imsd = GetMeshSelectDataInterface(triObject);    
    }
        
    if (!imsd)
    {
        Modifier *emMod = FindEditMeshModifier(node);
        if (!emMod)
        {            
            return;
        }

        imsd = GetMeshSelectDataInterface(emMod);    
    }

    if (!imsd)
    {
        return;
    }

    GenericNamedSelSetList *vertSelSets = &imsd->GetNamedVertSelList();

    numNamedSets = vertSelSets->Count();

    for (set = 0; set < numNamedSets; set++)
    {
        TSTR selSetName = *vertSelSets->names[set];       
        
        if (strncmp(selSetName.data(), "boneset", 7) == 0)                    
        {                        
            RwInt32 bone;         
            sscanf(&selSetName.data()[7], "%d", &bone);
                    
            for (i = 0; i < m_remapper.GetNumVertices(); i++)
            {                            
                int vertexIndex = m_remapper.GetVertex(i)->vertexIndex;
                              
                /* Find vertexIndex in a selection set */                                         
                if ((*vertSelSets->sets[set])[vertexIndex])                            
                {
                    int j;
                    for (j=0; j < CSNumBones; j++)
                    {
                        if (CSBoneIndexTags[j] == bone)
                        {                                 
                            skinVertexIndices[vertexMap[i]] = j;
                        }
                    }                          
                    skinMatrixWeights[vertexMap[i]].w0 = 1.0f;                        
                }                        
            }                 
        }                                 
    }
}

bool
IsSelSetSkinNode(INode *node)
{
    int selsetSkin = 0;

    if (node->GetUserPropInt("selsetskin", selsetSkin))
    {
        if (selsetSkin)
        {
            return true;
        }
    }
    return false;
}

void
DFFExport::ProcessSelSetSkinNode(INode *node, INode *rootNode, RpClump *clump)
{    
    Object *object = node->EvalWorldState(m_tvStart).obj;

    if (object && object->IsRenderable() && node->Renderable())
    {
        if (object->CanConvertToType(triObjectClassID))
        {
            RpAtomic *atomic = NULL;
            TriObject *triObject = (TriObject *)object->ConvertToType(0, triObjectClassID);
            Mesh *mesh = &triObject->mesh;
            RpGeometry *geometry;
            RwInt32 *vertexMap = NULL;

             /* remap for both texture vertices and smoothing groups */
            m_remapper.DoRemap(mesh, node->GetMtl(), m_limitUVs, m_limitUVMax,
                               m_weldThreshold, m_weldThresholdUV, m_2SidedMaterials, 
                               m_backfaceNormals, m_weldVertices, &m_WarningsList);

            geometry = CreateGeometryFromMesh(mesh, node->GetMtl());
            if (geometry)
            {                               
                int numKeyFrames = 1;

                SetGeometryTrianglesFromMesh(node, mesh, geometry);
                /* now the triangles and materials are set up 
                   build a vertex map sorted on material */
                vertexMap = GenerateVertexMapByMaterial(geometry);
            
                if (m_morphTargets)
                {
                    Interval v;
                    v = object->ObjectValidity(m_tvStart);
                    if (v.Start() > m_tvStart ||
                        v.End() < m_tvEnd)                    
                    {
                        numKeyFrames = m_nNumFrames / m_nAnimFrameInterval;
                        if (numKeyFrames % m_nAnimFrameInterval)
                        {
                            numKeyFrames++;
                        }
                    }                       
                }

                Matrix3 transform = m_objectOffset * m_scaleMatrix;
                SetGeometryKeyFramesFromNode(node, geometry, numKeyFrames, vertexMap, transform );

                RpGeometryUnlock(geometry);

                if (GeometryHasColoredMaterials(geometry))
                {
                    RpGeometrySetFlags(geometry, RpGeometryGetFlags(geometry) | rpGEOMETRYMODULATEMATERIALCOLOR);
                }
        
                atomic = RpAtomicCreate();
                if (atomic)
                {
                    RpAtomicSetFrame(atomic, RpClumpGetFrame(clump));
                    RpAtomicSetGeometry(atomic, geometry, 0);
                    RpGeometryDestroy(geometry);
                    RpClumpAddAtomic(clump, atomic);                        
                
                    /* we'll translate the skin into the root node's 
                       space */                        
                    RwMatrix *mat = RwMatrixCreate();
                    Matrix3 objLTM = GetNodeLTM(node);
                    Matrix3ToRwMatrix(objLTM, mat);
                    RpGeometryTransform(geometry, mat);
                    RwMatrixDestroy(mat);

                    /* if we're skinning, using CS and this 
                        is the skinnode create an initial vertex bone map */                                            
                    CalculateSelSetVertexBoneMap(node, triObject, vertexMap);
                   
                }
                else
                {
                    RpGeometryDestroy(geometry);
                }
            }
            /* RwFree remap structure */
            m_remapper.ResetReMap();

            /* get rid of the vertex map */
            if (vertexMap)
            {
                RwFree(vertexMap);
            }

            RpSkin *skin = RpSkinCreate(atomic, CSNumBones, skinMatrixWeights, skinVertexIndices, skinInverseMatrices, skinFlags);                
            if (skin)
            {
                int i;
                /* set the bonetags to match the frame hierarchy */
                for (i=0; i<CSNumBones; i++)
                {                    
                    skin->pBoneInfo[i].boneTag = CSBoneIndexTags[i];
                }
            }
            
            RwFree(skinMatrixWeights);
            skinMatrixWeights = NULL;
            RwFree(skinVertexIndices);
            skinVertexIndices = NULL;
        }
    }        
}

void
DFFExport::ProcessSelSetSkinNodesInHierarchy(INode *node, INode *rootNode, RpClump *clump)
{
    int numChildren, i;

    if (IsSelSetSkinNode(node))
    {        
        ProcessSelSetSkinNode(node, rootNode, clump);
    }
 
    numChildren = node->NumberOfChildren();
    for (i=0; i<numChildren; i++)
    {
        INode *childNode = node->GetChildNode(i);
        ProcessSelSetSkinNodesInHierarchy(childNode, rootNode, clump);    
    }    
}

